const path = require('path');
const HtmlWebpackPlugin = require('html-webpack-plugin');

module.exports = {
  entry: './src/app.jsx',
  output: {
    path: path.join(__dirname, 'build'),
    filename: 'rlcs-[hash].js'
  },
  plugins: [
    new HtmlWebpackPlugin({
      template: 'index.html'
    })
  ],
  module: {
    loaders: [
      {
        test: /.jsx?$/,
        loader: 'babel-loader',
        exclude: /node_modules/,
        query: {
          presets: ['es2015', 'react'],
          plugins: ['transform-object-rest-spread']
        }
      },
      { include: /\.json$/, loaders: ["json-loader"]},
      { test: /\.css$/, loader: "style-loader!css-loader" },
      { test: /\.scss$/, loader: "style-loader!css-loader!sass-loader" },
      { test: /\.(svg|jpg|png|mp4|webm|pdf)$/, loader: "file-loader" },
    ]
  },
  resolve: {
    extensions: ['', '.json', '.jsx', '.js'],
    alias: {
      config: path.join(__dirname, 'config', (process.env.NODE_ENV || 'development'))
    }
  }
};

