<?
// Plugin Name: Custom Types for RLCS
// Description: custom post types for RLCS

// Our custom post type function
function create_posttypes() {
  register_post_type( 'teams',
    array(
      'labels' => array(
        'name'          => __( 'Teams' ),
        'singular_name' => __( 'Team' )
      ),
      'public' => true,
      'supports' => array(),
      'has_archive' => true,
      'rewrite' => array('slug' => 'teams'),
      'show_in_rest' => true
    )
  );

  register_post_type( 'matches',
    array(
      'labels' => array(
        'name'          => __( 'Matches' ),
        'singular_name' => __( 'Match' )
      ),
      'public' => true,
      'supports' => array(),
      'has_archive' => true,
      'rewrite' => array('slug' => 'matches'),
      'show_in_rest' => true
    )
  );
}
add_action( 'init', 'create_posttypes' );

// Include ACF fields in rest-api responses
function wp_rest_api_alter() {
  register_api_field(
    array('post', 'teams', 'matches'),
    'fields',
    array(
      'get_callback'    => function($data, $field, $request, $type){
        if (function_exists('get_fields')) {
          return get_fields($data['id']);
        }
        return [];
      },
        'update_callback' => null,
        'schema'          => null,
      )
    );
  }
add_action( 'rest_api_init', 'wp_rest_api_alter');



?>
