resource "aws_sns_topic" "alarms" {
  name = "alarms"
}

module "slack" {
  source = "../../modules/lambda/cloudwatch_to_slack"
  kms_key = "${aws_kms_key.secrets.arn}" 
  hook_url = "AQICAHj6yiWqAlcOgGw+Gf5dKWZ/CHXGx1UScjsvYiF5CsQjJgENp6LWCyYydbMKTcSe8EmhAAAAsDCBrQYJKoZIhvcNAQcGoIGfMIGcAgEAMIGWBgkqhkiG9w0BBwEwHgYJYIZIAWUDBAEuMBEEDCWIHGWYJuCfV6iIUQIBEIBpC6uNgFb/kzBdbjVXYlmIuiIgNplJ7G88eIN1qpX+GaCEwCVq/1kHGhNBXlqodLXl8zLF5EQK1Lb43piKthTHXR9wAf5/tK5GZgLJEACsVo20f1WTrBMCBjzfyjnOKxOWeO2LZ20wqksq"
  channel = "esports-mon"
}

resource "aws_sns_topic_subscription" "slack" {
  topic_arn = "${aws_sns_topic.alarms.arn}"
  protocol = "lambda"
  endpoint = "${module.slack.function_arn}"
  endpoint_auto_confirms = true
}

resource "aws_lambda_permission" "with_sns" {
  statement_id = "AllowExecutionFromSNS"
  action = "lambda:InvokeFunction"
  function_name = "${module.slack.function_arn}"
  principal = "sns.amazonaws.com"
  source_arn = "${aws_sns_topic.alarms.arn}"
}

output "alarm_sns_topic_arn" {
  value = "${aws_sns_topic.alarms.arn}"
}
