module "ecs_cluster_programs" {
  source = "../../modules/ecs_cluster"
  name = "programs"
  region = "us-west-2"
  environment = "prod"
  availability_zones = ["${keys(module.common.subnets_public)}"]
  autoscale_max = 10
  autoscale_desired = 4
  ssh_pubkey = "~/.ssh/keys/twitch/ecs_esports_prod.pub"
  aws_profile = "twitch-esports-aws"
  vpc_id = "${module.common.vpc_id}"
  subnet_ids = ["${values(module.common.subnets_public)}"]
  instance_type = "m4.xlarge"
}

output "ecs_cluster_programs" {
  value = "${map(
    "name",               "programs",
    "id",                 "${module.ecs_cluster_programs.id}",
    "vpc_id",             "${module.common.vpc_id}",
    "subnet_ids",         "${join(",", values(module.common.subnets_public))}",
    "security_group_id",  "${module.ecs_cluster_programs.security_group_id}"
  )}"
}

module "ecs_cluster_tourney" {
  source = "../../modules/ecs_cluster"
  name = "tourney"
  region = "us-west-2"
  environment = "prod"
  availability_zones = ["${keys(module.common.subnets_public)}"]
  autoscale_max = 10
  autoscale_desired = 6
  ssh_pubkey = "~/.ssh/keys/twitch/ecs_esports_prod.pub"
  aws_profile = "twitch-esports-aws"
  vpc_id = "${module.common.vpc_id}"
  subnet_ids = ["${values(module.common.subnets_public)}"]
  instance_type = "m4.xlarge"
}

output "ecs_cluster_tourney" {
  value = "${map(
    "name",               "tourney",
    "id",                 "${module.ecs_cluster_tourney.id}",
    "vpc_id",             "${module.common.vpc_id}",
    "subnet_ids",         "${join(",", values(module.common.subnets_public))}",
    "security_group_id",  "${module.ecs_cluster_tourney.security_group_id}"
  )}"
}
