module "us-west-2" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/systems/terraform//modules/account_template/region/us-west-2?ref=bd20d8a46dff6bac58ec951e6d9cea17213bcf4b"
  region = "us-west-2"
  account_name = "twitch-esports-bts"
  vpc_cidr = "10.208.4.0/22"
  account_id = "329702468786"
  owner = "twitch-esports-bts@amazon.com"
  service = "esports"
  environment = "prod"
  credential_profile="twitch-esports-bts"
  public_subnet_shift = 4
  private_subnet_shift = 2
  public_subnet_offset = 12

  # We don't want BTS to have access to our internal network/DNS
  domain_name_servers = "8.8.8.8,8.8.4.4"
  external_ip = true
}

output "vpc_id" {
  value = "${module.us-west-2.vpc_id}"
}
