resource "aws_sns_topic" "alarms" {
  name = "alarms"
}

module "slack" {
  source = "../../modules/lambda/cloudwatch_to_slack"
  kms_key = "${aws_kms_key.secrets.arn}" 
  hook_url = "AQECAHiAS482BQsn9v3tZemuAkJekDhe3GWDg5xsn/7ViRlc/AAAALAwga0GCSqGSIb3DQEHBqCBnzCBnAIBADCBlgYJKoZIhvcNAQcBMB4GCWCGSAFlAwQBLjARBAw7+AqNMzxYY0LpLQsCARCAaf+fm5/Q2ci6aWQ/58nDI1STzWnECvVENJhUJ16lCyM7NJpxV/uJcRzyFkE2ibWm4+53gmM7M7hq/ZMf6qLn15b6G3VoSXr2nUoA930W1zD0eM2xwVZBgTuk5IMuU1PJZ6B8L2fvO8GRtw=="
  channel = "esports-mon"
}

resource "aws_sns_topic_subscription" "slack" {
  topic_arn = "${aws_sns_topic.alarms.arn}"
  protocol = "lambda"
  endpoint = "${module.slack.function_arn}"
  endpoint_auto_confirms = true
}

resource "aws_lambda_permission" "with_sns" {
  statement_id = "AllowExecutionFromSNS"
  action = "lambda:InvokeFunction"
  function_name = "${module.slack.function_arn}"
  principal = "sns.amazonaws.com"
  source_arn = "${aws_sns_topic.alarms.arn}"
}

output "alarm_sns_topic_arn" {
  value = "${aws_sns_topic.alarms.arn}"
}
