data "aws_availability_zones" "all" {}

module "ecs_cluster_bts" {
  source = "../../modules/ecs_cluster"
  name = "bts"
  region = "us-west-2"
  environment = "stage"
  availability_zones = [
    "${data.aws_availability_zones.all.names[0]}",
    "${data.aws_availability_zones.all.names[1]}",
    "${data.aws_availability_zones.all.names[2]}"
  ]
  autoscale_max = 4
  autoscale_desired = 1
  ssh_pubkey = "~/.ssh/keys/twitch/ecs_bts.pub"
  aws_profile = "twitch-esports-bts"
  vpc_id = "${module.us-west-2.vpc_id}"
  subnet_ids = ["${split(",", module.us-west-2.public_subnets)}"]
  instance_type = "m4.xlarge"
}

output "ecs_cluster_bts" {
  value = "${map(
    "name",               "bts",
    "id",                 "${module.ecs_cluster_bts.id}",
    "vpc_id",             "${module.us-west-2.vpc_id}",
    "subnet_ids",         "${module.us-west-2.public_subnets}",
    "security_group_id",  "${module.ecs_cluster_bts.security_group_id}"
  )}"
}
