module "ecs_cluster_programs" {
  source = "../../modules/ecs_cluster"
  name = "programs"
  region = "us-west-2"
  environment = "stage"
  availability_zones = ["${keys(module.common.subnets_public)}"]
  autoscale_max = 4
  autoscale_desired = 1
  ssh_pubkey = "~/.ssh/keys/twitch/ecs_esports_dev.pub"
  aws_profile = "twitch-esports-dev"
  vpc_id = "${module.common.vpc_id}"
  subnet_ids = ["${values(module.common.subnets_public)}"]
  instance_type = "m4.xlarge"
}

output "ecs_cluster_programs" {
  value = "${map(
    "name",               "programs",
    "id",                 "${module.ecs_cluster_programs.id}",
    "vpc_id",             "${module.common.vpc_id}",
    "subnet_ids",         "${join(",", values(module.common.subnets_public))}",
    "security_group_id",  "${module.ecs_cluster_programs.security_group_id}"
  )}"
}

module "ecs_cluster_tourney" {
  source = "../../modules/ecs_cluster"
  name = "tourney"
  region = "us-west-2"
  environment = "stage"
  availability_zones = ["${keys(module.common.subnets_public)}"]
  autoscale_max = 4
  autoscale_desired = 3
  ssh_pubkey = "~/.ssh/keys/twitch/ecs_esports_tourney.pub"
  aws_profile = "twitch-esports-dev"
  vpc_id = "${module.common.vpc_id}"
  subnet_ids = ["${values(module.common.subnets_public)}"]
  instance_type = "m4.xlarge"
}

output "ecs_cluster_tourney" {
  value = "${map(
    "name",               "tourney",
    "id",                 "${module.ecs_cluster_tourney.id}",
    "vpc_id",             "${module.common.vpc_id}",
    "subnet_ids",         "${join(",", values(module.common.subnets_public))}",
    "security_group_id",  "${module.ecs_cluster_tourney.security_group_id}"
  )}"
}
