provider "aws" {
  region = "us-west-2"
  profile = "twitch-esports-dev"
}

module "common" {
  source = "../../modules/variables/twitch-esports-dev/"
}

# Note: order is important, see subnets.tf
variable "availability_zones" {
  default = [
    "us-west-2a",
    "us-west-2b"
  ]
}

terraform {
  backend "s3" {
    bucket = "twitch-esports-dev"
    key = "account/terraform.tfstate"
    region = "us-east-1"
    profile = "twitch-esports-dev"
  }
}
