provider "aws" {
    region = "us-west-2"
    profile = "twitch-esports-dev"
}

module "us-west-2" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/systems/terraform//modules/account_template/region/us-west-2?ref=a33b56ae07e86f5c573fe28b872d5382bb65815f"
  region = "us-west-2"
  account_name = "twitch-esports-dev"
  vpc_cidr = "10.201.4.0/22"
  account_id = "157383839067"
  owner = "twitch-esports-dev@amazon.com"
  service = "esports"
  environment = "dev"
  credential_profile="twitch-esports-dev"
  public_subnet_shift = 4
  private_subnet_shift = 2
  public_subnet_offset = 12
}

output "vpc_id" {
  value = "${module.us-west-2.vpc_id}"
}
