##
# Users
##

resource "aws_iam_user" "mr" {
    name = "mr"
}

resource "aws_iam_user" "dl" {
    name = "dl"
}

resource "aws_iam_user" "cvp" {
    name = "cvp"
}


##
# Group Management
##

resource "aws_iam_group" "admins" {
	name = "admins"
}

resource "aws_iam_group_membership" "admins" {
	name = "admins"
	group = "${aws_iam_group.admins.name}"
	users = [
		"${aws_iam_user.mr.name}",
		"${aws_iam_user.dl.name}",
		"${aws_iam_user.cvp.name}",
    ]
}


##
# Policy Attachments
##

resource "aws_iam_policy" "admin-policy" {
    name = "admin-policy"
    description = "Allows '*' on '*'."
    policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": {
        "Effect": "Allow",
        "Action": "*",
        "Resource": "*"
    }
}
EOF
}

resource "aws_iam_group_policy_attachment" "admin-policy-attachment" {
    group = "${aws_iam_group.admins.name}"
    policy_arn = "${aws_iam_policy.admin-policy.arn}"
}
