# ALB alarms

resource "aws_cloudwatch_metric_alarm" "alb_4XX_threshold" {
  count = "${var.alb_4XX}"
  alarm_name = "${var.name_prefix}_alb_4XX_threshold"
  comparison_operator = "GreaterThanThreshold"
  namespace = "AWS/ApplicationELB"
  metric_name = "HTTPCode_Target_4XX_Count"
  evaluation_periods = "5"
  period = "60"
  statistic = "Sum"
  threshold = "${var.alb_4XX_threshold}"
  alarm_description = "Monitor 4XX Responses"
  insufficient_data_actions = ["${var.insufficient_data_actions}"]
  alarm_actions = ["${var.alarm_actions}"]
  ok_actions = ["${var.ok_actions}"]

  dimensions {
    LoadBalancer = "${var.alb_arn_suffix}"
  }
}

resource "aws_cloudwatch_metric_alarm" "alb_5XX_threshold" {
  count = "${var.alb_5XX}"
  alarm_name = "${var.name_prefix}_alb_5XX_threshold"
  comparison_operator = "GreaterThanThreshold"
  namespace = "AWS/ApplicationELB"
  metric_name = "HTTPCode_Target_5XX_Count"
  evaluation_periods = "3"
  period = "60"
  statistic = "Sum"
  threshold = "${var.alb_5XX_threshold}"
  alarm_description = "Monitor 5XX Responses"
  insufficient_data_actions = ["${var.insufficient_data_actions}"]
  alarm_actions = ["${var.alarm_actions}"]
  ok_actions = ["${var.ok_actions}"]

  dimensions {
    LoadBalancer = "${var.alb_arn_suffix}"
  }
}
