# Using rails_exception_count
# Note: A service that keeps restarting due to exceptions typically restarts 10-20 times per minute
resource "aws_cloudwatch_metric_alarm" "rails_exception_threshold" {
  count = "${var.rails}"
  alarm_name = "${var.name_prefix}_exception_threshold"
  comparison_operator = "GreaterThanThreshold"
  namespace = "${var.namespace}"
  metric_name = "rails_exception_count"
  evaluation_periods = "5"
  period = "60"
  statistic = "Sum"
  threshold = "${var.rails_exception_threshold}"
  alarm_description = "Monitor service flapping due to rails exceptions"
  insufficient_data_actions = ["${var.insufficient_data_actions}"]
  alarm_actions = ["${var.alarm_actions}"]
  ok_actions = ["${var.ok_actions}"]
}
