variable "name_prefix" {
  description = "Prefix for alarm names"
}

variable "service_name" {
  description = "Service name"
}

variable "alb_arn_suffix" {
  description = "Enabling any alb alarms requires this suffix"
  default = ""
}

variable "namespace" {
  description = "Metrics namespace for non-AWS metrics (e.g. rails, nginx)"
}

variable "insufficient_data_actions" { type = "list" }
variable "alarm_actions" { type = "list" }
variable "ok_actions" { type = "list" }

variable "alb_5XX" {
  description = "Enable 5XX alarms for ALB"
  default = false
}

variable "alb_5XX_threshold" {
  description = "Threshold for 5XX errors, 3x60 second periods"
  default = "20"
}

variable "alb_4XX" {
  description = "Enable 4XX alarms for ALB"
  default = false
}

variable "alb_4XX_threshold" {
  description = "Threshold for 4XX errors, 5x60 second periods"
  default = "50"
}

variable "rails" {
  description = "Enable rails alarms"
  default = false
}

variable "rails_exception_threshold" {
  description = "Threshold for rails exceptions, 5x60 second periods"
  default = "10"
}
