resource "aws_iam_role" "ecs_host_role" {
  name = "ecs_host_role_${var.name}"
  assume_role_policy = "${file("${path.module}/policies/ecs-role.json")}"
}

resource "aws_iam_role_policy" "ecs_instance_role_policy" {
  name = "ecs_instance_role_policy_${var.name}"
  policy = "${file("${path.module}/policies/ecs-instance-role-policy.json")}"
  role = "${aws_iam_role.ecs_host_role.id}"
}

resource "aws_iam_instance_profile" "ecs" {
  name = "ecs_instance_profile_${var.name}"
  path = "/"
  role = "${aws_iam_role.ecs_host_role.name}"
}
