resource "aws_security_group" "ecs" {
  name = "ecs_${var.name}"
  # TODO it obviously doesn't, but changing description requires resource 
  # re-creation for some reason, LUL.
  description = "Allows all traffic"
  vpc_id = "${var.vpc_id}"

  ingress {
    from_port = 0
    to_port = 0
    protocol = "-1"
    # https://git-aws.internal.justin.tv/dta/tf_twitch_subnets/blob/master/variables.tf
    cidr_blocks = [
      "10.0.0.0/8",
      "192.16.64.0/21",
      "199.9.248.0/21",
      "185.42.204.0/22",
      "127.0.0.1/32",
      "38.99.10.97/32",
      "38.104.129.210/32",
      "192.168.0.0/16",
      "45.113.128.0/22",
      "103.53.48.0/22",
      "52.223.240.0/20",
      "52.223.192.0/18",
      "98.173.4.128/27",
      "12.245.210.116/30",
      "136.24.146.78/32"
    ]
  }

  # Note: we need to allow 80/443 traffic from world to allow public services.
  # ALB is a layer 7/4 router. While it offers layer 7 functionality, it routes
  # packets directly rather than acting like a reverse proxy. As such, we can't
  # control access at the ALB level. However, since clients connect on 80/443
  # on the ALB but we don't use these ports on the instances directly, this is
  # not a security risk imo. Access to all other ports is still restricted to
  # internal networks.

  ingress {
    from_port = 80
    to_port = 80
    protocol = "tcp"
    cidr_blocks = ["0.0.0.0/0"]
  }

  ingress {
    from_port = 443
    to_port = 443
    protocol = "tcp"
    cidr_blocks = ["0.0.0.0/0"]
  }

  ingress {
    from_port = 0
    to_port = 0
    protocol = "-1"
    self = true
  }

  egress {
    from_port = 0
    to_port = 0
    protocol = "-1"
    cidr_blocks = ["0.0.0.0/0"]
  }
}
