variable "aws_profile" {
  description = "AWS credentials profile."
}

variable "region" {
  description = "The AWS region to create resources in."
}

variable "environment" {
  description = "Service environment."
}

variable "availability_zones" {
  description = "The availability zones"
  type = "list"
}

variable "name" {
  description = "The name of the Amazon ECS cluster."
  default = "main"
}

# See http://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI_launch_latest.html
variable "amis" {
  description = "Which AMI to spawn. Defaults to the AWS ECS optimized images."
  # TODO: support other regions.
  default = {
    us-east-1 = "ami-9eb4b1e5"
    us-east-2 = "ami-1c002379"
    us-west-1 = "ami-4a2c192a"
    us-west-2 = "ami-1d668865"
  }
}


variable "autoscale_min" {
  default = "1"
  description = "Minimum autoscale (number of EC2)"
}

variable "autoscale_max" {
  default = "10"
  description = "Maximum autoscale (number of EC2)"
}

variable "autoscale_desired" {
  default = "4"
  description = "Desired autoscale (number of EC2)"
}


variable "instance_type" {
  default = "t2.micro"
}

variable "ssh_pubkey" {
  description = "Path to an SSH public key"
  default = "~/.ssh/id_rsa.pub"
}

variable "vpc_id" {}

variable "subnet_ids" {
  type = "list"
}

output "name" {
  value = "${var.name}"
}

output "id" {
  value = "${aws_ecs_cluster.main.id}"
}

output "security_group_id" {
  value = "${aws_security_group.ecs.id}"
}
