# Test CloudWatch alarms:
# aws cloudwatch set-alarm-state --profile twitch-esports-dev --alarm-name rlcs_running_count --state-value ALARM --state-reason :wutface:

resource "aws_iam_role" "lambda" {
  name = "lambda"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "lambda.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_iam_role_policy" "lambda_kms" {
  name = "lambda_kms"
  role = "${aws_iam_role.lambda.id}"
  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
    {
        "Sid": "Stmt1443036478000",
        "Effect": "Allow",
        "Action": [
            "kms:Decrypt"
        ],
        "Resource": [
            "${var.kms_key}"
        ]
    }
    ]
}
EOF
}

data "archive_file" "lambda_zip" {
  type        = "zip"
  source_dir  = "${path.module}/src"
  output_path = "${path.module}/lambda.zip"
}

resource "aws_lambda_function" "cloudwatch_to_slack" {
  filename = "${path.module}/lambda.zip"
  function_name = "cloudwatch_to_slack"
  role = "${aws_iam_role.lambda.arn}"
  handler = "index.handler"
  source_code_hash = "${data.archive_file.lambda_zip.output_base64sha256}"
  runtime = "nodejs4.3"
  kms_key_arn = "${var.kms_key}"
  timeout = 10

  environment {
    variables = {
      kmsEncryptedHookUrl = "${var.hook_url}"
      slackChannel = "${var.channel}"
    }
  }
}
