# Created by systems/terraform for account
# https://git-aws.internal.justin.tv/systems/terraform/blob/master/modules/account_template/region/us-west-2/sg.tf
data "aws_security_group" "twitch_subnets" { name = "twitch_subnets" }

resource "aws_alb_target_group" "service" {
  count = "${var.alb}"
  name = "${var.name}"
  port = 80
  protocol = "HTTP"
  vpc_id = "${var.vpc_id}"

  health_check {
    path = "/"
    protocol = "HTTP"
    matcher = "200"
  }

  stickiness {
    type = "lb_cookie"
    cookie_duration = "86400"
  }
}

resource "aws_alb" "service" {
  count = "${var.alb}"
  name = "${var.name}"
  internal = "${var.internal}"
  subnets = ["${var.subnet_ids}"]
  security_groups = [
    "${data.aws_security_group.twitch_subnets.id}",
    "${aws_security_group.service.id}" 
  ]
}

resource "aws_alb_listener" "service" {
  count = "${var.alb}"
  load_balancer_arn = "${aws_alb.service.id}"
  port = "80"
  protocol = "HTTP"

  default_action {
    target_group_arn = "${aws_alb_target_group.service.id}"
    type = "forward"
  }
}

resource "aws_alb_listener" "service_ssl" {
  count = "${var.alb_ssl}"
  load_balancer_arn = "${aws_alb.service.id}"
  port = "443"
  protocol = "HTTPS"
  ssl_policy = "ELBSecurityPolicy-2015-05"
  certificate_arn = "${var.certificate_arn}"

  default_action {
    target_group_arn = "${aws_alb_target_group.service.id}"
    type = "forward"
  }
}
