# At least one container should be running
resource "aws_cloudwatch_metric_alarm" "service_running_count" {
  alarm_name = "${var.prefix}_running_count"
  comparison_operator = "LessThanThreshold"
  evaluation_periods = "1"
  metric_name = "CPUUtilization"
  namespace = "AWS/ECS"
  period = "60"
  statistic = "SampleCount"
  threshold = "1"
  alarm_description = "Monitor RUNNING count"
  insufficient_data_actions = ["${var.alarm_sns_topic_arn}"]
  alarm_actions = ["${var.alarm_sns_topic_arn}"]
  ok_actions = ["${var.alarm_sns_topic_arn}"]
  dimensions = {
    ServiceName = "${var.name}"
    ClusterName = "${var.cluster}"
  }
}
