# Nginx specific CW logs metric filters

resource "aws_cloudwatch_log_metric_filter" "nginx_2XX_count" {
  count = "${var.nginx}"
  name = "${var.name}_2XX_count"
  pattern = "[ip, sep, sep2, timestamp, request, status=2*, size, sep3, agent, sep4]"
  log_group_name = "${var.name}"

  metric_transformation {
    name = "nginx_2XX_count"
    namespace = "${var.cluster}/${var.name}/${var.env}"
    value = "1"
  }
}

resource "aws_cloudwatch_log_metric_filter" "nginx_4XX_count" {
  count = "${var.nginx}"
  name = "${var.name}_4XX_count"
  pattern = "[ip, sep, sep2, timestamp, request, status=4*, size, sep3, agent, sep4]"
  log_group_name = "${var.name}"

  metric_transformation {
    name = "nginx_4XX_count"
    namespace = "${var.cluster}/${var.name}/${var.env}"
    value = "1"
  }
}

resource "aws_cloudwatch_log_metric_filter" "nginx_5XX_count" {
  count = "${var.nginx}"
  name = "${var.name}_5XX_count"
  pattern = "[ip, sep, sep2, timestamp, request, status=5*, size, sep3, agent, sep4]"
  log_group_name = "${var.name}"

  metric_transformation {
    name = "nginx_5XX_count"
    namespace = "${var.cluster}/${var.name}/${var.env}"
    value = "1"
  }
}
