# Rails specific CW logs metric filters

resource "aws_cloudwatch_log_metric_filter" "rails_2XX_count" {
  count = "${var.rails}"
  name = "${var.name}_2XX_count"
  pattern = "[cid, completed, status=2*, ...]"
  log_group_name = "${var.name}"

  metric_transformation {
    name = "rails_2XX_count"
    namespace = "${var.cluster}/${var.name}/${var.env}/responses"
    value = "1"
  }
}

resource "aws_cloudwatch_log_metric_filter" "rails_5XX_count" {
  count = "${var.rails}"
  name = "${var.name}_5XX_count"
  pattern = "[cid, completed, status=5*, ...]"
  log_group_name = "${var.name}"

  metric_transformation {
    name = "rails_5XX_count"
    namespace = "${var.cluster}/${var.name}/${var.env}"
    value = "1"
  }
}

resource "aws_cloudwatch_log_metric_filter" "rails_4XX_count" {
  count = "${var.rails}"
  name = "${var.name}_4XX_count"
  pattern = "[cid, exception=\"ActionController::RoutingError\", ...]"
  log_group_name = "${var.name}"

  metric_transformation {
    name = "rails_4XX_count"
    namespace = "${var.cluster}/${var.name}/${var.env}"
    value = "1"
  }
}

# Rails w/ lograge options (JSON logs)

resource "aws_cloudwatch_log_metric_filter" "json_2XX_count" {
  count = "${var.rails_json}"
  name = "${var.name}_2XX_count"
  pattern = "{ $.status = 2* }"
  log_group_name = "${var.name}"

  metric_transformation {
    name = "rails_2XX_count"
    namespace = "${var.cluster}/${var.name}/${var.env}"
    value = "1"
  }
}

resource "aws_cloudwatch_log_metric_filter" "json_4XX_count" {
  count = "${var.rails_json}"
  name = "${var.name}_4XX_count"
  pattern = "{ $.status = 4* }"
  log_group_name = "${var.name}"

  metric_transformation {
    name = "rails_4XX_count"
    namespace = "${var.cluster}/${var.name}/${var.env}"
    value = "1"
  }
}

resource "aws_cloudwatch_log_metric_filter" "json_5XX_count" {
  count = "${var.rails_json}"
  name = "${var.name}_5XX_count"
  pattern = "{ $.status = 5* }"
  log_group_name = "${var.name}"

  metric_transformation {
    name = "rails_5XX_count"
    namespace = "${var.cluster}/${var.name}/${var.env}"
    value = "1"
  }
}

resource "aws_cloudwatch_log_metric_filter" "json_duration" {
  count = "${var.rails_json}"
  name = "${var.name}_duration"
  pattern = "{ $.duration > 0 }"
  log_group_name = "${var.name}"

  metric_transformation {
    name = "rails_duration"
    namespace = "${var.cluster}/${var.name}/${var.env}"
    value = "$.duration"
  }
}

# Generic Rails stuff

resource "aws_cloudwatch_log_metric_filter" "exception_count" {
  count = "${var.rails_json + var.rails}"
  name = "${var.name}_exception_count"
  pattern = "Exception"
  log_group_name = "${var.name}"

  metric_transformation {
    name = "rails_exception_count"
    namespace = "${var.cluster}/${var.name}/${var.env}"
    value = "1"
  }
}
