data "aws_ecs_cluster" "cluster" {
  cluster_name = "${var.cluster}"
}

resource "aws_ecs_service" "service_worker" {
  count = "${1 - var.alb}"

  name = "${var.name}"
  cluster = "${data.aws_ecs_cluster.cluster.id}"
  task_definition = "${var.task_definition}"
  desired_count = "${var.desired_count}"
  depends_on = ["aws_iam_role_policy.ecs_service_role_policy"]

  lifecycle {
    ignore_changes = ["task_definition"]
  }
}

resource "aws_ecs_service" "service" {
  count = "${var.alb}"

  name = "${var.name}"
  cluster = "${data.aws_ecs_cluster.cluster.id}"
  task_definition = "${var.task_definition}"
  desired_count = "${var.desired_count}"
  iam_role = "${aws_iam_role.ecs_service_role.arn}"
  depends_on = ["aws_iam_role_policy.ecs_service_role_policy", "aws_alb.service"]

  load_balancer {
    target_group_arn = "${aws_alb_target_group.service.id}"
    container_name = "${var.name}"
    container_port = "${var.container_port}"
  }

  lifecycle {
    ignore_changes = ["task_definition"]
  }
}
