resource "aws_route53_record" "service_internal" {
  zone_id = "${var.internal_zone_id}" 
  name = "${var.name}"
  type = "A"

  alias {
    name = "${aws_alb.service.dns_name}"
    zone_id = "${aws_alb.service.zone_id}"
    evaluate_target_health = false
  }
}

resource "aws_route53_record" "service_external" {
  zone_id = "${var.external_zone_id}"
  name = "${var.name}.${var.env}"
  type = "A"

  alias {
    name = "${aws_alb.service.dns_name}"
    zone_id = "${aws_alb.service.zone_id}"
    evaluate_target_health = false
  }
}
