variable "name" {}

# Prefix is prefixed to any resource names
variable "prefix" {}

variable "container_port" {
  default = 3000
}

variable "internal" {
  description = "Internal service, ALB only routes traffic from internal networks."
  default = false
}

variable "alb" {
  description = "If true, attach ALB to service"
  default = false
}

variable "alb_ssl" {
  description = "If true, create SSL listener for ALB"
  default = false
}

variable "certificate_arn" {
  default = ""
}

variable "desired_count" {
  default = 1
}

variable "env" {}

variable "cluster" {
  description = "ECS cluster name"
  default = "default"
}

variable "subnet_ids" {
  type = "list"
}
variable "security_group_id" {}
variable "vpc_id" {}
variable "task_definition" {}
variable "internal_zone_id" {}
variable "external_zone_id" {}

variable "alarm_sns_topic_arn" {
  description = "SNS topic for all alarms, monitoring."
}

variable "nginx" {
  description = "Nginx fronted service. Enables nginx metrics"
  default = false
}

variable "rails" {
  description = "Rails service. Enables rails metrics and other rails specific resources"
  default = false
}

variable "rails_json" {
  description = "Rails service w/ Lograge JSON output. Enables rails metrics and other rails specific resources. Disable 'rails' when you enable this."
  default = false
}

output "alb_dns_name" {
  value = "${aws_alb.service.dns_name}"
}

output "alb_name" {
  value = "${aws_alb.service.name}"
}

output "alb_zone_id" {
  value = "${aws_alb.service.zone_id}"
}
