provider "aws" {
    region = "us-east-1"
    profile = "twitch-esports-dev"
}

module "common" {
  source = "../../../modules/variables/twitch-esports-dev/"
}

data "terraform_remote_state" "dev" {
  backend = "s3"
  config {
    bucket = "twitch-esports-dev"
    key = "tfstate/esports/terraform/dev/raw"
    profile = "twitch-esports-dev"
    region = "us-east-1"
  }
}

module "service" {
  source = "../../../modules/service"
  name = "specs"
  prefix = "specs"
  container_port = "3000"
  env = "dev"
  vpc_id = "${lookup(data.terraform_remote_state.dev.ecs_cluster_programs, "vpc_id")}"
  cluster_name = "${lookup(data.terraform_remote_state.dev.ecs_cluster_programs, "name")}"
  cluster_id = "${lookup(data.terraform_remote_state.dev.ecs_cluster_programs, "id")}"
  subnet_ids = "${split(",", lookup(data.terraform_remote_state.dev.ecs_cluster_programs, "subnet_ids"))}"
  security_group_id = "${lookup(data.terraform_remote_state.dev.ecs_cluster_programs, "security_group_id")}"
}
