#!/bin/bash
#
# Requires 
# awscli >= 1.11.91

if [ -z "$1" ]; then
    echo "No environment specified." >&2
    exit 1
fi

name=ting-backend
region=us-west-2
ecr_staging=157383839067.dkr.ecr.us-west-2.amazonaws.com/ting-backend
ecr_production=

function ensure {
    "$@"
    local status=$?
    if [ $status -ne 0 ]; then
        echo "error with $1" >&2
        exit 1
    fi
    return $status
}


read -p "Build container? [Y/N]" -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
  ensure ./gen_version.sh
  ensure docker build -t ${name}:latest -f docker/Dockerfile .
fi

read -p "Push docker image? [Y/N]" -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
  case "$1" in
    staging)
      `aws ecr get-login --no-include-email --region ${region} --profile twitch-esports-dev`
      if [ $? -ne 0 ]; then `aws ecr get-login --no-include-email --region ${region}`; fi
      ensure docker tag ${name}:latest ${ecr_staging}:latest
      ensure docker push ${ecr_staging}:latest
      ;;
    production)
      `aws ecr get-login --no-include-email --region ${region} --profile twitch-esports-aws`
      if [ $? -ne 0 ]; then `aws ecr get-login --no-include-email --region ${region}`; fi
      ensure docker tag ${name}:latest ${ecr_production}:latest
      ensure docker push ${ecr_production}:latest
      ;;
  esac
fi

