#!/bin/sh

set -e

scriptdir="$(readlink -f "$(dirname "$0")")"

branch="$(git rev-parse --abbrev-ref HEAD)"
commit="$(git rev-parse --short HEAD)"

cat <<EOF | gofmt > "${scriptdir}/src/ting/version.go"
package main

const (
	BRANCH = "${branch}"
	COMMIT = "${commit}"
	VERSION = BRANCH + " " + COMMIT
)
EOF
