CREATE TABLE IF NOT EXISTS "channels" (
    "id"        INTEGER PRIMARY KEY,
    "settings"  JSONB NOT NULL DEFAULT '{}'::JSONB
);

CREATE TABLE IF NOT EXISTS "questions" (
    "id"            SERIAL PRIMARY KEY,
    "channel_id"    INTEGER NOT NULL,
    "text"          TEXT NOT NULL,
    "active_from"   TIMESTAMP,
    "active_until"  TIMESTAMP,
    "responses"     INTEGER NOT NULL DEFAULT 0,
    "settings"      JSONB NOT NULL DEFAULT '{}'::JSONB
);
CREATE INDEX IF NOT EXISTS "questions_by_active_from" ON "questions" ("active_from");

CREATE TABLE IF NOT EXISTS "answers" (
    "id"           SERIAL PRIMARY KEY,
    "question_id"  INTEGER NOT NULL,
    "text"         TEXT NOT NULL,
    "emote_id"     INTEGER,
    "match"        TEXT,
    "is_correct"   BOOLEAN NOT NULL,
    "responses"    INTEGER NOT NULL DEFAULT 0
);

CREATE TABLE IF NOT EXISTS "users" (
    "id"         SERIAL PRIMARY KEY,
    "opaque_id"  TEXT,
    "twitch_id"  TEXT,
    "username"   TEXT
);
CREATE UNIQUE INDEX IF NOT EXISTS "users_by_opaque_id" ON "users" ("opaque_id");
CREATE UNIQUE INDEX IF NOT EXISTS "users_by_twitch_id" ON "users" ("twitch_id");

CREATE TABLE IF NOT EXISTS "user_answers" (
    "question_id"  INTEGER NOT NULL,
    "user_id"      INTEGER NOT NULL,
    "answer_id"    INTEGER NOT NULL,
    "message"      TEXT,
    PRIMARY KEY ("question_id", "user_id")
);
CREATE INDEX IF NOT EXISTS "user_answers_by_question_id" ON "user_answers" ("question_id");

CREATE TABLE IF NOT EXISTS "leaderboard" (
    "channel_id"  INTEGER NOT NULL,
    "user_id"     INTEGER NOT NULL,
    "correct"     INTEGER NOT NULL DEFAULT 0,
    "answered"    INTEGER NOT NULL DEFAULT 0,
    "percent"     REAL NOT NULL DEFAULT 0,
    PRIMARY KEY ("channel_id", "user_id")
);
CREATE INDEX IF NOT EXISTS "leaderboard_by_correct" ON "leaderboard" ("channel_id", "correct" DESC);
CREATE INDEX IF NOT EXISTS "leaderboard_by_percent" ON "leaderboard" ("channel_id", "percent" DESC);
