package handlers

import (
	"ting/model"

	"github.com/gin-gonic/gin"
)

func addAnswerHandlers(engine gin.IRouter, db *model.DB) {
	engine.OPTIONS("/answer", makeOptionsHandler("POST"))

	engine.POST("/answer", PostAnswerHandler(db))
}

// POST /answer
func PostAnswerHandler(db *model.DB) gin.HandlerFunc {
	h := NewHandler(
		// Require channel_id and question_id for validation?
		DefParam("user_id", "string", "query", true, nil),
		DefParam("answer_id", "int", "query", true, nil),
	)

	return h.Wrap(func(ctx *gin.Context) {
		opaqueID := h.StringParam("user_id")
		answerID := h.IntParam("answer_id")

		if jwtOpaqueID, found := ctx.Get("opaque_id"); found && jwtOpaqueID != opaqueID {
			ctx.JSON(403, gin.H{"error": "cannot vote on behalf of another user"})
		} else if question, err := db.FindQuestionForAnswer(answerID); err != nil {
			replyError(ctx, err)
		} else if question == nil {
			ctx.JSON(404, gin.H{"error": "no question with this answer"})
		} else if jwtChannelID, found := ctx.Get("channel_id"); found && jwtChannelID != question.ChannelID {
			ctx.JSON(403, gin.H{"error": "cannot post answer to a different channel"})
		} else if userAnswer, err := question.AddUserAnswer(opaqueID, answerID, false); err != nil {
			replyError(ctx, err)
		} else {
			ctx.JSON(200, userAnswer)
		}
	})
}
