package handlers

import (
	"ting/model"

	"github.com/gin-gonic/gin"
)

func addLeaderboardHandlers(engine gin.IRouter, db *model.DB) {
	engine.OPTIONS("/leaderboard", makeOptionsHandler("GET"))

	engine.GET("/leaderboard", GetLeaderboardHandler(db))
}

// GET /leaderboard
func GetLeaderboardHandler(db *model.DB) gin.HandlerFunc {
	h := NewHandler(
		DefParam("channel_id", "int", "query", true, nil),
		DefParam("sort", "string", "query", false, model.LeaderSortCorrect),
		DefParam("limit", "int", "query", false, 5),
	)

	return h.Wrap(func(ctx *gin.Context) {
		if board, err := db.GetLeaderboard(
			h.IntParam("channel_id"),
			h.StringParam("sort"),
			h.IntParam("limit"),
		); err != nil {
			replyError(ctx, err)
		} else {
			ctx.JSON(200, board)
		}
	})
}
