// +build test

package handlers

import (
	"fmt"
	"testing"
	"ting/model"
)

func (ht handlerTest) GetLeaderboardTests(t *testing.T) {
	// Handler just wraps a call to `model.GetLeaderboard`, which has its own suite of tests,
	// so... not much to test here.
	channel := ht.db.NewTestChannel(t, nil)
	url := fmt.Sprintf("/leaderboard?channel_id=%d", channel.ID)

	t.Run("200", func(t *testing.T) {
		code, body := ht.GET(t, url)
		if code != 200 {
			t.Fatalf("unexpected error: HTTP %d\nbody: %s", code, body)
		}
		lb := model.ParseLeaderboard(t, body)
		if lb.ChannelID != channel.ID {
			t.Fatalf("wrong channel ID: %d; expected %d", lb.ChannelID, channel.ID)
		}
	})

	t.Run("BadSort", func(t *testing.T) {
		if code, body := ht.GET(t, url+"&sort=foo"); code != 400 {
			t.Fatalf("wrong HTTP status code: %d; expected 400\nbody: %s", code, body)
		} else if reply := parseErrReply(t, body); reply.Error != `invalid leaderboard sort: "foo"` {
			t.Fatalf("wrong error message: %q\n", reply.Error)
		}
	})
}
