package logging

import (
	"bytes"
	"encoding/json"

	"github.com/sirupsen/logrus"
)

type jsonFormatter struct{}

func (f *jsonFormatter) Format(e *logrus.Entry) ([]byte, error) {
	buf := e.Buffer
	if buf == nil {
		buf = new(bytes.Buffer)
	}

	// `encoding/json` doesn't play nice with `error`
	data := make(map[string]interface{}, len(e.Data)+2)
	for k, v := range e.Data {
		if err, ok := v.(error); ok {
			data[k] = err.Error()
		} else {
			data[k] = v
		}
	}
	e.Data["level"] = e.Level.String()
	e.Data["time"] = fmtTime(e.Time)

	if err := json.NewEncoder(buf).Encode(e.Data); err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
