package logging

import (
	"bytes"
	"fmt"
	"strings"

	"github.com/sirupsen/logrus"
)

var colorLevel map[logrus.Level]string

const noColor string = "\x1B[0m"

func init() {
	colorLevel = map[logrus.Level]string{
		logrus.DebugLevel: "\x1B[2;37mDEBUG\x1B[m", // dim white
		logrus.InfoLevel:  "\x1B[36mINFO\x1B[m",    // blue
		logrus.WarnLevel:  "\x1B[33mWARN\x1B[m",    // yellow
		logrus.ErrorLevel: "\x1B[31mERROR\x1B[m",   // red
		logrus.FatalLevel: "\x1B[1;31mFATAL\x1B[m", // bright red
		logrus.PanicLevel: "\x1B[1;31mPANIC\x1B[m", // bright red
	}
}

type textFormatter struct {
	color bool
}

func (f *textFormatter) Format(e *logrus.Entry) ([]byte, error) {
	buf := e.Buffer
	if buf == nil {
		buf = new(bytes.Buffer)
	}

	if f.color {
		buf.WriteString(colorLevel[e.Level])
	} else {
		buf.WriteString(strings.ToUpper(e.Level.String()))
	}
	fmt.Fprintf(buf, " [%s] %s\n", fmtTime(e.Time), e.Message)

	return buf.Bytes(), nil
}
