package model

import (
	"fmt"

	"github.com/jmoiron/sqlx"
	_ "github.com/lib/pq"
)

type DB struct {
	*sqlx.DB
}

func InitDB(dbUrl string) (*DB, error) {
	conn, err := sqlx.Connect("postgres", dbUrl)
	if err != nil {
		return nil, fmt.Errorf("error connecting to %q: %s", dbUrl, err)
	}
	return &DB{conn}, nil
}

func (db *DB) Close() {
	db.DB.Close()
}
