package set

type IntSet map[int]void

func NewIntSet(xs ...int) IntSet {
	s := make(map[int]void, len(xs))
	for _, x := range xs {
		s[x] = empty
	}
	return s
}

func FromIntMap(m map[int]interface{}) IntSet {
	s := NewIntSet()
	for k, _ := range m {
		s.Add(k)
	}
	return s
}

func (s IntSet) Add(x int) bool {
	if _, found := s[x]; found {
		return true
	}
	s[x] = empty
	return false
}

func (s IntSet) Has(x int) bool {
	_, found := s[x]
	return found
}

func (s IntSet) Remove(x int) (found bool) {
	if _, found = s[x]; found {
		delete(s, x)
	}
	return found
}

func (s IntSet) Values() []int {
	xs := make([]int, 0, len(s))
	for x, _ := range s {
		xs = append(xs, x)
	}
	return xs
}

func (s IntSet) Copy() IntSet {
	return NewIntSet(s.Values()...)
}

func (s1 IntSet) Diff(s2 IntSet) IntSet {
	result := NewIntSet()
	for x, _ := range s1 {
		if _, found := s2[x]; !found {
			result.Add(x)
		}
	}
	return result
}

func (s1 IntSet) Union(s2 IntSet) IntSet {
	result := s1.Copy()
	for x, _ := range s2 {
		result.Add(x)
	}
	return result
}

func (s1 IntSet) Intersection(s2 IntSet) IntSet {
	if len(s1) == 0 || len(s2) == 0 {
		return NewIntSet()
	}

	result := NewIntSet()
	s2Found := 0
	for x, _ := range s1 {
		if s2.Has(x) {
			result.Add(x)
			s2Found += 1
			if s2Found > len(s2) {
				break
			}
		}
	}
	return result
}

func (s1 IntSet) Comm(s2 IntSet) (left, both, right IntSet) {
	left = s1.Diff(s2)
	both = s1.Intersection(s2)
	right = s2.Diff(s1)
	return
}
