package set

type StringSet map[string]void

func NewStringSet(xs ...string) StringSet {
	s := make(map[string]void, len(xs))
	for _, x := range xs {
		s[x] = empty
	}
	return s
}

func FromStringMap(m map[string]interface{}) StringSet {
	s := NewStringSet()
	for k, _ := range m {
		s.Add(k)
	}
	return s
}

func (s StringSet) Add(x string) bool {
	if _, found := s[x]; found {
		return true
	}
	s[x] = empty
	return false
}

func (s StringSet) Has(x string) bool {
	_, found := s[x]
	return found
}

func (s StringSet) Remove(x string) (found bool) {
	if _, found = s[x]; found {
		delete(s, x)
	}
	return found
}

func (s StringSet) Values() []string {
	xs := make([]string, 0, len(s))
	for x, _ := range s {
		xs = append(xs, x)
	}
	return xs
}

func (s StringSet) Copy() StringSet {
	return NewStringSet(s.Values()...)
}

func (s1 StringSet) Diff(s2 StringSet) StringSet {
	result := NewStringSet()
	for x, _ := range s1 {
		if _, found := s2[x]; !found {
			result.Add(x)
		}
	}
	return result
}

func (s1 StringSet) Union(s2 StringSet) StringSet {
	result := s1.Copy()
	for x, _ := range s2 {
		result.Add(x)
	}
	return result
}

func (s1 StringSet) Intersection(s2 StringSet) StringSet {
	if len(s1) == 0 || len(s2) == 0 {
		return NewStringSet()
	}

	result := NewStringSet()
	s2Found := 0
	for x, _ := range s1 {
		if s2.Has(x) {
			result.Add(x)
			s2Found += 1
			if s2Found > len(s2) {
				break
			}
		}
	}
	return result
}

func (s1 StringSet) Comm(s2 StringSet) (left, both, right StringSet) {
	left = s1.Diff(s2)
	both = s1.Intersection(s2)
	right = s2.Diff(s1)
	return
}
