package types

import (
	"encoding/json"
	"fmt"
)

type Any interface{}

type Void struct{}

var Empty Void

func init() {
	Empty = Void{}
}

type StringMap map[string]interface{}

// Implements `database/sql.Scan`.
func (m *StringMap) Scan(src interface{}) error {
	if bytes, ok := src.([]byte); !ok {
		return fmt.Errorf("cannot parse map from %T; expected array of bytes", src)
	} else {
		return json.Unmarshal(bytes, m)
	}
}

func (m StringMap) Copy() StringMap {
	mCopy := make(StringMap, len(m))
	for k, v := range m {
		mCopy[k] = v
	}
	return mCopy
}

func (m StringMap) With(k string, v interface{}) StringMap {
	mCopy := m.Copy()
	mCopy[k] = v
	return mCopy
}

func (m StringMap) Keys() (keys []string) {
	if m == nil {
		return keys
	}
	keys = make([]string, 0, len(m))
	for k, _ := range m {
		keys = append(keys, k)
	}
	return keys
}
