import _ from 'lodash';
import React from 'react';
import ReactDOM from 'react-dom';

import { Emote } from '../emote';

export class Answer extends React.Component {
  constructor(...args) {
    super(...args);
  }

  render() {
    const {
      emote,
      text,
      active,
      progress,
      percentage,
      count,
      winner,
      chosen,
      onClick
    } = this.props;
    const classes = ['answer', emote];

    if (active) { classes.push('active'); }
    if (winner) { classes.push('winner'); }
    if (chosen) { classes.push('chosen'); }

    return <div onClick={onClick} className={classes.join(' ')} data-count={count || '0'}>
      <Emote id={this.emote} />
      <div className="text">
        <span>{text}</span>
        <span className="count">{count || 0}</span>
      </div>
      <div className="progress-container">
        <div className="progress" style={{
          width: `${progress}%`,
          height: `${progress}%`
          }}>
          <span className="percentage">{percentage}%</span>
        </div>
      </div>
    </div>;
  }
}
