import React from 'react';
import ReactDOM from 'react-dom';

import * as emoteDb from './emotes.json';
const emotes = Object.values(emoteDb);

export class Emote extends React.Component {
  static get defaultProps() {
    return {
      id: 25
    }
  }

  constructor(...args) {
    super(...args);

    this.emote = emotes.find((emote) => this.props.id === emote.id || this.props.id === emote.code);
    this.emote.url = `https://static-cdn.jtvnw.net/emoticons/v1/${this.emote.id}/4.0`;
  }

  render() {
    return <div className="emote">
      <img className="glow" src={this.emote.url} />
      <img src={this.emote.url} />
    </div>;
  }
}
