import _ from 'lodash';
import React from 'react';
import ReactDOM from 'react-dom';
import { Answer } from '../answer';

export class Question extends React.Component {
  constructor() {
    super();

    this.resetActive(true);

    this.state = {
      count: {},
      active: {},
      messages: []
    };

    // this.renderBars = _.debounce(this.renderBars, 1100, {
    //   maxWait: 1100
    // });
  }

  resetActive(wait) {
    if (!wait) {
      this.setState({ active: {} });
    }
    this.resetActiveTimeout = setTimeout(this.resetActive.bind(this), 400);
  }

  // @user - whether this vote is being registered for the current user
  registerVote(answer, user = false) {
    if (!answer || !answer.id) {
      throw 'Missing answer or ID';
      return;
    }

    const { id } = answer;
    let { count } = this.state;
    count[id] = count[id]
      ? count[id] + 1
      : 1;

    let newState = { count };
    if (user) newState.choice = id;

    this.setState(newState);
  }

  addMessage(message) {
    const { text, answers, timer } = this.props;

    if (typeof timer === 'number' && timer <= 0) return;

    for (let answer of answers) {
      const { match } = answer;
      const regex = new RegExp(match, 'ig');
      if (regex.exec(message.body)) {
        this.registerVote(answer);
      }
    }

    if (this.props.debug) {
      let messages = this.state.messages.concat([message]);
      this.setState({
        messages: messages.slice(-10, 11)
      });
    }
  }

  initializeChat(chat) {
    if (chat) {
      console.log('connecting chat', chat);
      chat.connect();
      chat.on('message', (channel, user, message, self) => {
        this.addMessage({
          channel: channel,
          user: user,
          body: message
        });
      });
    }
  }

  initializeTimer(timer) {
    if (timer) {
      this.timerTick();
    }
  }

  componentWillReceiveProps(nextProps) {
    let { timer, chat } = nextProps;
    console.log('chat', chat);
    this.initializeChat(chat);
    this.initializeTimer(timer);
  }

  componentDidMount() {
    let { timer, chat } = this.props;
    console.log('chat', chat);
    this.initializeChat(chat);
    this.initializeTimer(timer);
  }

  timerTick() {
    setTimeout(() => {
      this.setState({
        timer: this.state.timer - 1
      });
      if (this.state.timer - 1 >= 0) {
        this.timerTick();
      }
    }, 1000);
  }

  renderBars() {
    const max = _.max(Object.values(this.state.count));
    const registerVote = this.registerVote;
    const { text, answers, relative } = this.props;
    let winner;

    return _.map(answers, (answer, idx) => {
      const { emote } = answer;
      let percentage = Math.round(this.state.count[emote] / _.sum(_.values(this.state.count)) * 100.0) || 0;
      let progress = percentage;
      let winnerState = false;
      const count = this.state.count[emote];

      if (relative) {
        progress = Math.round((count / max) * 100.0) || 0;
      }

      if (count > 0 && !winner && max === count) {
        winner = true;
        winnerState = true;
      }

      return <Answer
        onClick={registerVote.bind(this, answer)}
        key={emote}
        emote={emote}
        text={answer.text}
        chosen={this.state.choice && this.state.choice == answer.id}
        active={this.state.active[emote]}
        progress={progress}
        percentage={percentage}
        count={this.state.count[emote]}
        winner={winnerState}
        />;
    });
  }

  randomizeWinner() {
    // let emote = this.state.emotes[Math.ceil(Math.random(this.state.emotes.length) * this.state.emotes.length) - 1];
    // if (emote.match(/:/)) { [emote] = emote.split(':'); }
    // this.state.count[emote] = (_.max(Object.values(this.state.count)) || 0) + 1;
    // this.setState(this.state);
  }

  render() {
    const { text, answers, timer } = this.props;
    let classes = ['question', this.state.choice ? 'answered' : 'unanswered'];

    const messages = this.state.messages.map((message) => {
      if (this.props.debug) {
        return <div>[{message.channel}] &lt;{message.user['display-name']}&gt; {message.body}</div>;
      }
    });

    const debug = this.props.debug ? <div className="debug">
      <a onClick={this.randomizeWinner.bind(this)}>Random Winner</a>
      <pre>{JSON.stringify(this.state.count)}</pre>
    </div> : null;

    const bars = this.renderBars();

    let timerItem = timer
      ? <span className="right">{timer}</span>
      : undefined;

    return <div className={classes.join(' ')}>
      {debug}
      <div className="header">
        {/*<div className="logo"/>*/}
        <div className="text">
          <span className="left">{text}</span>
          {timerItem}
        </div>
      </div>
      <div className="answers">
        {bars}
      </div>
      {messages}
    </div>;
  }
}
