import React from 'react';
import ReactDOM from 'react-dom';

import tmi from 'tmi.js';

require('./stylesheets/main.scss');

const url = new URL(window.location.href);
const anchor = url.searchParams.get('anchor') || 'video_overlay'; // or 'panel'
const panel = anchor === 'panel';

let config = {
  title: '',
  theme: 'quiz_example',
  color: 'white',
  background: panel ? 'rgba(0,0,0,1)' : 'rgba(0,0,0,0)',
  channels: ['TwitchPresents'],
  debug: true,
  timer: false,
  relative: false,
  answers: ['Kappa', 'LUL']
};

// Scan url params to override defaults.
Object.keys(config).forEach((key) => {
  const param = url.searchParams.get(key);
  if (param != undefined) {
    switch(key) {
      // Boolean parameters
      case 'relative':
        config[key] = true;
        break;
      // CSV parameters
      case 'channels':
      case 'answers':
        config[key] = param.split(',');
        break;
      case 'timer':
        config[key] = parseInt(param, 10);
        break;
      default:
        config[key] = param;
    }
  }
});

console.log('Config: ', config);

// Emulate [tbd] API schema for URL params.
const answers = config.answers.map((answer) => {
  if (typeof answer !== 'object') {
    const [emote, text] = answer.split(':');
    return {
      id: emote,
      emote,
      match: emote,
      text: text || emote
    }
  }
  return answer;
});

const question = {
  text: 'Hello World?',
  answers
}

import { Question } from './components/question';

const styles = {
  color: config.color,
  background: config.background
};

document.body.style.background = config.background;
document.body.style.color = config.color;

const body = document.getElementsByTagName('body')[0];
body.classList.add(config.theme);
body.classList.add(anchor);

function render(options = {}) {
  const { chat } = options;

  ReactDOM.render(<div style={styles}><Question
      text={question.text}
      answers={question.answers}
      relative={config.relative}
      timer={config.timer}
      chat={chat}
      debug={config.debug}
    /></div>,
    document.getElementById('app'));
}

Twitch.ext.onAuthorized((data) => {
  const parts = data.token.split('.');
  const payload = JSON.parse(window.atob(parts[1]));
  console.log(data.channel_id, data, payload);

  fetch(`https://api.twitch.tv/kraken/channels/${data.channelId}`,
      {
        headers: {
          'Accept': 'application/vnd.twitchtv.v5+json',
          'Client-ID': 'yp6iguls0rhkoqrcknnpjhlfqqtzok'
        }
      }
    ).then(response => response.json()).
    then((channel) => {
      console.log('channel', channel);
      const chat = new tmi.client({
        connection: {
          secure: true,
          reconnect: true
        },
        channels: [`#${channel.name}`]
      });
      render({ chat });
    });
});

const chat = new tmi.client({
  connection: {
    secure: true,
    reconnect: true
  },
  channels: config.channels
});

render({ chat });
