var path = require('path');
var webpack = require('webpack');
var HtmlWebpackPlugin = require('html-webpack-plugin');
var ExtractTextPlugin = require('extract-text-webpack-plugin');

var production = process.env.NODE_ENV === 'production';

module.exports = {
  entry: './src/index.jsx',
  output: {
    path: path.resolve(__dirname, 'dist'),
    filename: 'bundle-[hash].js'
  },
  resolve: {
    extensions: ['.js', '.jsx']
  },
  plugins: production ? [
    new HtmlWebpackPlugin({
      title: 'Ting',
      filename: 'index.html',
      template: path.resolve(__dirname, 'src/index.html')
    }),
    new ExtractTextPlugin('style-[hash].css'),
    new webpack.optimize.AggressiveMergingPlugin()
  ] : [
    new HtmlWebpackPlugin({
      title: 'Ting',
      filename: 'index.html',
      template: path.resolve(__dirname, 'src/index.html')
    }),
    new ExtractTextPlugin('style-[hash].css'),
  ],
  devServer: {
    https: true,
    disableHostCheck: true,
    host: '0.0.0.0',
    port: '8080'
  },
  module: {
    rules: [
      { test: /.scss$/,
        loader: ExtractTextPlugin.extract({
          fallback: 'style-loader',
          use: ['css-loader', 'sass-loader']
        })
      },
      { test: /.(gif|png|jpg|jpeg)$/, loader: 'file-loader' },
      {
        test: /.jsx?$/,
        loader: 'babel-loader',
        exclude: /node_modules/,
        query: {
          presets: ['env', 'react']
        }
      },
      {
        test: /\.(eot|svg|ttf|woff|woff2)$/,
        loader: 'file-loader?name=public/fonts/[name].[ext]'
      }
    ]
  }
};
