#!/bin/bash

name=tourney-backend
region=us-west-2
ecr_staging=157383839067.dkr.ecr.us-west-2.amazonaws.com/tourney-backend
ecr_production=954268612818.dkr.ecr.us-west-2.amazonaws.com/tourney-backend
branch=`git rev-parse --abbrev-ref @`
version=`git rev-parse --short HEAD`

function ensure {
    "$@"
    local status=$?
    if [ $status -ne 0 ]; then
        echo "error with $1" >&2
        exit 1
    fi
    return $status
}

version=`git rev-parse --short HEAD`

read -p "Build docker image? [Y/N]" -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
  export NODE_ENV=$1
  export VERSION=$version
  case "$1" in
    staging)
      export API_CLIENT_ID=2CsZPf674C3
      export API_URL=https://tourney-edge.staging.esports.internal.justin.tv
      export TWITCH_CALLBACK_URL=http://tourney-admin.staging.esports.internal.justin.tv/auth/callback/twitch
      ;;
    production)
      export API_CLIENT_ID=0Bl4YcjDoQB
      export API_URL=https://api.rlcs.gg
      export TWITCH_CALLBACK_URL=https://admin.rlcs.gg/auth/callback/twitch
      ;;
  esac
  docker run \
    -v `pwd`:/app \
    -e NODE_ENV \
    -e VERSION \
    -e API_CLIENT_ID \
    -e API_URL \
    -e TWITCH_CALLBACK_URL \
    node:7.7 /bin/sh -c "cd /app && yarn install && npm rebuild node-sass && yarn build && rm -rf node_modules/"
  ensure docker build -t ${name}:latest -f docker/Dockerfile .
fi

read -p "Push docker image? [Y/N]" -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
  case "$1" in
    production)
      `aws ecr get-login --no-include-email --region ${region} --profile twitch-esports-aws`
      if [ $? -ne 0 ]; then `aws ecr get-login --region ${region}`; fi
      ensure docker tag ${name}:latest ${ecr_production}:latest
      ensure docker push ${ecr_production}:latest
      ;;
    staging)
      `aws ecr get-login --no-include-email --region ${region} --profile twitch-esports-dev`
      if [ $? -ne 0 ]; then `aws ecr get-login --region ${region}`; fi
      ensure docker tag ${name}:latest ${ecr_staging}:latest
      ensure docker push ${ecr_staging}:latest
      ;;
  esac
fi

