import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';

import { authUser, denormalize, UserSchema } from 'tourney-sdk-react';
import { LoginButton } from '../loginButton';
import { Login } from '../login';
import * as filter from '../../utils/filter';
import { history } from '../../index';

import { withRouter } from 'react-router';
import { Link } from 'react-router-dom';
import { Segment, Button, Menu, Image, Icon, Header } from 'semantic-ui-react';

import 'semantic-ui-css/semantic.min.css';
const style = require('./style.scss');

class AppComponent extends React.Component<any, any> {
  public static mapStateToProps(state: any) {
    const user = denormalize(state.tourney.users.current, UserSchema, state.tourney);
    const loading = Object.keys(state.tourney.requests).length > 0;
    return {
      loading,
      user
    }
  }

  public componentDidMount() {
    // Callback from Twitch OAuth -- ask edge for user information for the
    // token and store it if valid.
    if (this.props.location.pathname === '/auth/callback/twitch') {
      this.props.dispatch(authUser(
        filter.get('state'),
        filter.get('code')
      )).then(() => history.push('/'));
    }
  }

  public componentDidUpdate(prevProps: any, prevState: any) {
    if (!prevProps.user && this.props.user) {
      if (!this.isAdmin()) {
        this.logout();
      }
    }
  }

  public render() {
    if (!this.props.user) {
      return <Login loading={this.props.loading} />
    }

    return <div>
      <Menu
        vertical
        inverted
        fixed="left"
        style={{ width: '200px' }}
      >
        <Menu.Item><LoginButton user={this.props.user} /></Menu.Item>
        <Menu.Item as={Link} to="/">Home</Menu.Item>
        <Menu.Item as={Link} to="/settings"><Icon name="gamepad" /> Settings</Menu.Item>
        <Menu.Item>
          <Menu.Header>Games</Menu.Header>
          <Menu.Menu>
            <Menu.Item as={Link} to="/games">All Games</Menu.Item>
          </Menu.Menu>
        </Menu.Item>
         <Menu.Item>
          <Menu.Header>Articles</Menu.Header>
          <Menu.Menu>
            <Menu.Item as={Link} to="/articles">All Articles</Menu.Item>
          </Menu.Menu>
        </Menu.Item>
        <Menu.Item>
          <Menu.Header>Teams</Menu.Header>
          <Menu.Menu>
            <Menu.Item as={Link} to="/teams">All Teams</Menu.Item>
          </Menu.Menu>
        </Menu.Item>
        <Menu.Item>
          <Menu.Header>Tournaments</Menu.Header>
          <Menu.Menu>
            <Menu.Item as={Link} to="/tournaments">All Tournaments</Menu.Item>
            <Menu.Item as={Link} to="/tournament_entries">Tournament Entries</Menu.Item>
          </Menu.Menu>
        </Menu.Item>
        <Menu.Item>
          <Menu.Header>Matches</Menu.Header>
          <Menu.Menu>
            <Menu.Item as={Link} to="/series">All Series</Menu.Item>
            <Menu.Item as={Link} to="/matches">All Matches</Menu.Item>
          </Menu.Menu>
        </Menu.Item>
        <Menu.Item>
          <Menu.Header>Events</Menu.Header>
          <Menu.Menu>
            <Menu.Item as={Link} to="/events">All Events</Menu.Item>
          </Menu.Menu>
        </Menu.Item>
        <Menu.Item>
          <Menu.Header>Users</Menu.Header>
          <Menu.Menu>
            <Menu.Item as={Link} to="/users">All Users</Menu.Item>
            <Menu.Item as={Link} to="/players">All Players</Menu.Item>
          </Menu.Menu>
        </Menu.Item>
      </Menu>
      <div style={{ marginLeft: 200 }}>
        {this.props.children}
      </div>
    </div>;
  }

  private isAdmin() {
    return this.props.user.roles.findIndex((role: any) => role === 'admin') !== -1;
  }

  private logout() {
    localStorage.removeItem('token');
    window.location.href = '/';
  }
}
export const App = withRouter(connect(AppComponent.mapStateToProps)(AppComponent));
