import { EditorState, convertToRaw } from 'draft-js';
import * as Immutable from 'immutable';
import {
  Editor,
  createEditorState,
} from 'medium-draft';

import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';
import { Link } from 'react-router-dom';
import { Container, Modal, Segment, Grid, Button, Menu } from 'semantic-ui-react';
import {
  denormalize,
  ArticleSchema,
  createArticle,
  getArticles,
  getArticle,
  createOrUpdateArticle,
  ArticleModel,
  getGames
} from 'tourney-sdk-react';

import { RichEditor } from '../editor/rich-editor';
import { Form } from '../form';
import { Article } from './model';

export class ArticleDetailComponent extends React.Component<any, any> {
  public blockButtons: any[];
  public inlineButtons: any[];

  constructor(props: any) {
    super(props);
    this.state = {
      article: {},
      loading: true,
    };
  }

  public componentDidMount() {
    const { articleId } = this.props.match.params;
    this.props.dispatch(getGames());
    if (articleId === 'new') {
      // let emptyEditorState = EditorState.createEmpty().getCurrentContent();
      // let emptyEditorJSON = convertToRaw(emptyEditorState);
      this.setState({
        article: {
          body: JSON.stringify(convertToRaw(createEditorState().getCurrentContent()))
        },
        loading: false
      });
    } else {
      this.props.dispatch(getArticle(articleId))
        .then((article: any) => {
          // editor needs json, not string
          // article.body = JSON.parse(article.body);
          this.setState({
            article,
            loading: false
          });
        });
    }
  }

  public handleFormChange(e: Event, article: ArticleModel) {
    this.setState({ article });
  }

  public onSuccess(json: any) {
    const { articleId } = this.props.match.params;
    if (articleId === 'new') {
      this.props.history.push(`/articles/${json.id}`);
      // this reload needs to be done since article isn't saving after creation properly.
      window.location.reload();
    }
  }

  public render() {
    const { article, loading } = this.state;
    if (loading) {
      return <Segment padded loading={loading}/>;
    }

    return (
      <Container fluid>
        <Menu attached="top">
          <Menu.Item><Link to="/articles">Back To Articles</Link></Menu.Item>
        </Menu>
        <Segment padded>
          <Form
            for={Article}
            object={this.state.article}
            action={createOrUpdateArticle}
            schema={ArticleSchema}
            onSuccess={this.onSuccess.bind(this)}
            onChange={this.handleFormChange.bind(this)}
          />
        </Segment>
      </Container>
    );
  }

  private updateDraft(editorState: EditorState) {
    this.setState({
      article: {
        ...this.state.article,
        body: editorState
      }
    });
  }
}

export const ArticleDetail = connect()(ArticleDetailComponent);
