import { EditorState, convertToRaw } from 'draft-js';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';
import { Link } from 'react-router-dom';
import {
  denormalize,
  ArticleSchema,
  UserSchema,
  createArticle,
  getArticles,
  deleteArticle,
  createTournamentEntry,
  publishArticle,
  getGames
} from 'tourney-sdk-react';

import { Form } from '../form';
import { ArticleList } from './list';
import { Article } from './model';

import { Container, Modal, Segment, Grid, Button, Menu } from 'semantic-ui-react';

class ArticleComponent extends React.Component<any, any> {
  public static mapStateToProps(state: any) {
    const articleIds = Object.keys(state.tourney.articles);
    const articles = denormalize(articleIds, [ArticleSchema], state.tourney);
    const user = denormalize(state.tourney.users.current, UserSchema, state.tourney);
    return {
      articles,
      user
    };
  }

  public constructor(...args: any[]) {
    super(...args);

    this.state = {
      loading: true
    };
  }

  public componentDidMount() {
    Promise.all([
      this.props.dispatch(getArticles()),
      this.props.dispatch(getGames())
    ])
      .then((response: any) => this.setState({ loading: false }));
  }

  public showArticleForm() {
    this.setState({ form: { visible: true } });
  }

  public hideModal(e: Event) {
    if (e && e.preventDefault) {
      e.preventDefault();
    }

    this.setState({
      form: { visible: false }
    });
  }

  public handleFormChange(article: any) {
    this.setState({
      form: { article, visible: true }
    });
  }

  public deleteArticle(article: any) {
    this.props.dispatch(deleteArticle(article.id));
  }

  public editArticle(article: any) {
    this.props.history.push(`/articles/${article.id}`);
  }

  public publishArticle(article: any) {
    this.props.dispatch(publishArticle(article));
  }

  public render() {
    let listActions = {
      edit: this.editArticle.bind(this),
      delete: this.deleteArticle.bind(this),
      publish: this.publishArticle.bind(this),
    };

    return <Container fluid>
        <Menu attached="top">
          <Menu.Item><Link to="/articles/new">Create New</Link></Menu.Item>
        </Menu>

        <Segment padded attached="bottom" loading={this.state.loading}>
          <ArticleList
            articles={this.props.articles}
            actions={listActions}
          />
        </Segment>
      </Container>;
  }
}

export const Articles = connect(ArticleComponent.mapStateToProps)(ArticleComponent);
export * from './list';
export * from './detail';
