import * as _ from 'lodash';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { connect } from 'react-redux';

import { Link } from 'react-router-dom';
import { Table, Button } from 'semantic-ui-react';

import { ArticleModel, UserModel } from 'tourney-sdk-react';

export class ArticleList extends React.Component<any, any> {
  public action(action: Function, article: Object) {
    return () => action(article);
  }

  public render() {
    let articles: ArticleModel[] = this.props.articles;

    let articleRows = _.map(articles, (article, id) => {
      const rowActions = _.map(
        this.props.actions,
        (action: Function, name: string) =>
        <Button key={name} onClick={this.action(action, article).bind(this)}>{name}</Button>
      );

      return <Table.Row key={id}>
        <Table.Cell>{article.id}</Table.Cell>
        <Table.Cell>{article.title}</Table.Cell>
        <Table.Cell>{article.state}</Table.Cell>
        <Table.Cell>{rowActions}</Table.Cell>
      </Table.Row>;
    });

    return <Table>
      <Table.Header>
        <Table.Row>
          <Table.HeaderCell>#</Table.HeaderCell>
          <Table.HeaderCell>Title</Table.HeaderCell>
          <Table.HeaderCell>State</Table.HeaderCell>
          <Table.HeaderCell>Actions</Table.HeaderCell>
        </Table.Row>
      </Table.Header>
      <Table.Body>
        {articleRows}
      </Table.Body>
    </Table>;
  }
}
