import { UserModel, UserSchema, ArticleModel, GameModel } from 'tourney-sdk-react';
import { User } from '../user/model';

export class Article implements ArticleModel {
  public static properties = [
    { name: 'title',
      type: 'text' },
    { name: 'slug',
      type: 'text' },
    { name: 'published_at',
      type: 'datetime-local',
      default: new Date()
    },
    { name: 'flags',
      type: 'select-multiple',
      options: [{
        text: 'Featured',
        value: 'featured'
      }]},
    { name: 'parent_type',
      type: 'select',
      options: [{
        text: 'Game',
        value: 'Game'
      }]
    },
    { name: 'parent_id',
      type: 'select',
      collection: 'tourney.games' },
    { name: 'state',
      type: 'select',
      options: [{
        text: 'Draft',
        value: 'draft'
      }, {
        text: 'Review',
        value: 'review'
      }, {
        text: 'Final',
        value: 'final'
      }]},
    { name: 'cover',
      type: 'image-upload' },
    { name: 'body',
      type: 'draft' },
  ];
  public id: string;
  public title: string;
  public slug: string;
  public body: string;
  public league_id: string;
  public state: string;
  public published_at: string;
  // public created_at: string;
  // public updated_at: string;
  public author: UserModel;
}
