import { EditorState } from 'draft-js';
import * as React from 'react';

import { ToolbarIcon } from './toolbar-icon';

const INLINE_STYLES = [
  { icon: 'fa fa-bold', style: 'BOLD' },
  { icon: 'fa fa-italic', style: 'ITALIC' }
];

export interface InlineToolbarProps {
  editorState: EditorState;
  onToggle: any;
  position: any;
}

export class InlineToolbar extends React.Component<any, any> {
  public render() {
    const { editorState, onToggle, position } = this.props;
    const currentStyle = editorState.getCurrentInlineStyle();
    const inlineStyles = INLINE_STYLES.map((type: any) => {
      return (
        <ToolbarIcon
          key={type.label || type.icon}
          active={currentStyle.has(type.style)}
          label={type.label}
          icon={type.icon}
          onToggle={onToggle}
          style={type.style}
        />
      );
    });

    return (
      <div
        className="toolbar"
        id="inlineToolbar"
        style={position}
      >
        <ul className="toolbar-icons">
          {inlineStyles}
        </ul>
      </div>
    );
  }
}
